import json

def calculate_averages(filepath):
    style_sum = 0
    engaging_sum = 0
    coherence_sum = 0
    total_items = 0

    # Read JSONL file
    with open(filepath, 'r', encoding='utf-8') as file:
        for line in file:
            item = json.loads(line.strip())
            style_sum += item['style']
            engaging_sum += item['engaging']
            coherence_sum += item['coherence']
            total_items += 1

    # Compute the Average score
    style_avg = style_sum / total_items if total_items > 0 else 0
    engaging_avg = engaging_sum / total_items if total_items > 0 else 0
    coherence_avg = coherence_sum / total_items if total_items > 0 else 0

    return style_avg, engaging_avg, coherence_avg

def main():
    # Save Path 
    filepath = './output_hae_score.jsonl' 
    
    # compute average
    style_avg, engaging_avg, coherence_avg = calculate_averages(filepath)
    
    # Print the results
    print(f"Average Style Score: {style_avg}")
    print(f"Average Engaging Score: {engaging_avg}")
    print(f"Average Coherence Score: {coherence_avg}")

if __name__ == "__main__":
    main()
